/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class FireworkRocketEntity
extends ProjectileEntity
implements IRendersAsItem {
    private static final DataParameter<ItemStack> field_184566_a = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_187196_f);
    private static final DataParameter<OptionalInt> field_191512_b = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_218814_r);
    private static final DataParameter<Boolean> field_213895_d = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_187198_h);
    private int field_92056_a;
    private int field_92055_b;
    private LivingEntity field_191513_e;

    public FireworkRocketEntity(EntityType<? extends FireworkRocketEntity> entityType, World world) {
        super((EntityType<? extends ProjectileEntity>)entityType, world);
    }

    public FireworkRocketEntity(World world, double d, double d2, double d3, ItemStack itemStack) {
        super((EntityType<? extends ProjectileEntity>)EntityType.field_200810_x, world);
        this.field_92056_a = 0;
        this.func_70107_b(d, d2, d3);
        int n = 1;
        if (!itemStack.func_190926_b() && itemStack.func_77942_o()) {
            this.field_70180_af.func_187227_b(field_184566_a, itemStack.func_77946_l());
            n += itemStack.func_190925_c("Fireworks").func_74771_c("Flight");
        }
        this.func_213293_j(this.field_70146_Z.nextGaussian() * 0.001, 0.05, this.field_70146_Z.nextGaussian() * 0.001);
        this.field_92055_b = 10 * n + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
    }

    public FireworkRocketEntity(World world, @Nullable Entity entity, double d, double d2, double d3, ItemStack itemStack) {
        this(world, d, d2, d3, itemStack);
        this.func_212361_a(entity);
    }

    public FireworkRocketEntity(World world, ItemStack itemStack, LivingEntity livingEntity) {
        this(world, livingEntity, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), itemStack);
        this.field_70180_af.func_187227_b(field_191512_b, OptionalInt.of(livingEntity.func_145782_y()));
        this.field_191513_e = livingEntity;
    }

    public FireworkRocketEntity(World world, ItemStack itemStack, double d, double d2, double d3, boolean bl) {
        this(world, d, d2, d3, itemStack);
        this.field_70180_af.func_187227_b(field_213895_d, bl);
    }

    public FireworkRocketEntity(World world, ItemStack itemStack, Entity entity, double d, double d2, double d3, boolean bl) {
        this(world, itemStack, d, d2, d3, bl);
        this.func_212361_a(entity);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184566_a, ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(field_191512_b, OptionalInt.empty());
        this.field_70180_af.func_187214_a(field_213895_d, false);
    }

    @Override
    public boolean func_70112_a(double d) {
        return d < 4096.0 && !this.func_191511_j();
    }

    @Override
    public boolean func_145770_h(double d, double d2, double d3) {
        return super.func_145770_h(d, d2, d3) && !this.func_191511_j();
    }

    @Override
    public void func_70071_h_() {
        Object object;
        super.func_70071_h_();
        if (this.func_191511_j()) {
            if (this.field_191513_e == null) {
                this.field_70180_af.func_187225_a(field_191512_b).ifPresent(n -> {
                    Entity entity = this.field_70170_p.func_73045_a(n);
                    if (entity instanceof LivingEntity) {
                        this.field_191513_e = (LivingEntity)entity;
                    }
                });
            }
            if (this.field_191513_e != null) {
                if (this.field_191513_e.func_184613_cA()) {
                    object = this.field_191513_e.func_70040_Z();
                    double \u26032 = 1.5;
                    double \u26033 = 0.1;
                    Vector3d \u26034 = this.field_191513_e.func_213322_ci();
                    this.field_191513_e.func_213317_d(\u26034.func_72441_c(((Vector3d)object).field_72450_a * 0.1 + (((Vector3d)object).field_72450_a * 1.5 - \u26034.field_72450_a) * 0.5, ((Vector3d)object).field_72448_b * 0.1 + (((Vector3d)object).field_72448_b * 1.5 - \u26034.field_72448_b) * 0.5, ((Vector3d)object).field_72449_c * 0.1 + (((Vector3d)object).field_72449_c * 1.5 - \u26034.field_72449_c) * 0.5));
                }
                this.func_70107_b(this.field_191513_e.func_226277_ct_(), this.field_191513_e.func_226278_cu_(), this.field_191513_e.func_226281_cx_());
                this.func_213317_d(this.field_191513_e.func_213322_ci());
            }
        } else {
            if (!this.func_213889_i()) {
                double d = this.field_70123_F ? 1.0 : 1.15;
                this.func_213317_d(this.func_213322_ci().func_216372_d(d, 1.0, d).func_72441_c(0.0, 0.04, 0.0));
            }
            object = this.func_213322_ci();
            this.func_213315_a(MoverType.SELF, (Vector3d)object);
            this.func_213317_d((Vector3d)object);
        }
        object = ProjectileHelper.func_234618_a_(this, this::func_230298_a_);
        if (!this.field_70145_X) {
            this.func_70227_a((RayTraceResult)object);
            this.field_70160_al = true;
        }
        this.func_234617_x_();
        if (this.field_92056_a == 0 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187631_bo, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.field_92056_a;
        if (this.field_70170_p.field_72995_K && this.field_92056_a % 2 < 2) {
            this.field_70170_p.func_195594_a(ParticleTypes.field_197629_v, this.func_226277_ct_(), this.func_226278_cu_() - 0.3, this.func_226281_cx_(), this.field_70146_Z.nextGaussian() * 0.05, -this.func_213322_ci().field_72448_b * 0.5, this.field_70146_Z.nextGaussian() * 0.05);
        }
        if (!this.field_70170_p.field_72995_K && this.field_92056_a > this.field_92055_b) {
            this.func_213893_k();
        }
    }

    private void func_213893_k() {
        this.field_70170_p.func_72960_a(this, (byte)17);
        this.func_191510_k();
        this.func_70106_y();
    }

    @Override
    protected void func_213868_a(EntityRayTraceResult entityRayTraceResult) {
        super.func_213868_a(entityRayTraceResult);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_213893_k();
    }

    @Override
    protected void func_230299_a_(BlockRayTraceResult blockRayTraceResult) {
        BlockPos blockPos = new BlockPos(blockRayTraceResult.func_216350_a());
        this.field_70170_p.func_180495_p(blockPos).func_196950_a(this.field_70170_p, blockPos, this);
        if (!this.field_70170_p.func_201670_d() && this.func_213894_l()) {
            this.func_213893_k();
        }
        super.func_230299_a_(blockRayTraceResult);
    }

    private boolean func_213894_l() {
        ItemStack itemStack = this.field_70180_af.func_187225_a(field_184566_a);
        CompoundNBT \u26032 = itemStack.func_190926_b() ? null : itemStack.func_179543_a("Fireworks");
        ListNBT \u26033 = \u26032 != null ? \u26032.func_150295_c("Explosions", 10) : null;
        return \u26033 != null && !\u26033.isEmpty();
    }

    private void func_191510_k() {
        float f = 0.0f;
        ItemStack \u26032 = this.field_70180_af.func_187225_a(field_184566_a);
        CompoundNBT \u26033 = \u26032.func_190926_b() ? null : \u26032.func_179543_a("Fireworks");
        ListNBT listNBT = \u2603 = \u26033 != null ? \u26033.func_150295_c("Explosions", 10) : null;
        if (\u2603 != null && !\u2603.isEmpty()) {
            f = 5.0f + (float)(\u2603.size() * 2);
        }
        if (f > 0.0f) {
            if (this.field_191513_e != null) {
                this.field_191513_e.func_70097_a(DamageSource.func_233548_a_(this, this.func_234616_v_()), 5.0f + (float)(\u2603.size() * 2));
            }
            double d = 5.0;
            Vector3d \u26034 = this.func_213303_ch();
            List<LivingEntity> \u26035 = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(5.0));
            for (LivingEntity livingEntity : \u26035) {
                if (livingEntity == this.field_191513_e || this.func_70068_e(livingEntity) > 25.0) continue;
                boolean \u26037 = false;
                for (int i = 0; i < 2; ++i) {
                    Vector3d vector3d = new Vector3d(livingEntity.func_226277_ct_(), livingEntity.func_226283_e_(0.5 * (double)i), livingEntity.func_226281_cx_());
                    BlockRayTraceResult \u26036 = this.field_70170_p.func_217299_a(new RayTraceContext(\u26034, vector3d, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this));
                    if (((RayTraceResult)\u26036).func_216346_c() != RayTraceResult.Type.MISS) continue;
                    \u26037 = true;
                    break;
                }
                if (!\u26037) continue;
                float f2 = f * (float)Math.sqrt((5.0 - (double)this.func_70032_d(livingEntity)) / 5.0);
                livingEntity.func_70097_a(DamageSource.func_233548_a_(this, this.func_234616_v_()), f2);
            }
        }
    }

    private boolean func_191511_j() {
        return this.field_70180_af.func_187225_a(field_191512_b).isPresent();
    }

    public boolean func_213889_i() {
        return this.field_70180_af.func_187225_a(field_213895_d);
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 17 && this.field_70170_p.field_72995_K) {
            if (!this.func_213894_l()) {
                for (int i = 0; i < this.field_70146_Z.nextInt(3) + 2; ++i) {
                    this.field_70170_p.func_195594_a(ParticleTypes.field_197598_I, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70146_Z.nextGaussian() * 0.05, 0.005, this.field_70146_Z.nextGaussian() * 0.05);
                }
            } else {
                ItemStack itemStack = this.field_70180_af.func_187225_a(field_184566_a);
                CompoundNBT \u26032 = itemStack.func_190926_b() ? null : itemStack.func_179543_a("Fireworks");
                Vector3d \u26033 = this.func_213322_ci();
                this.field_70170_p.func_92088_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), \u26033.field_72450_a, \u26033.field_72448_b, \u26033.field_72449_c, \u26032);
            }
        }
        super.func_70103_a(by);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("Life", this.field_92056_a);
        compoundNBT.func_74768_a("LifeTime", this.field_92055_b);
        ItemStack itemStack = this.field_70180_af.func_187225_a(field_184566_a);
        if (!itemStack.func_190926_b()) {
            compoundNBT.func_218657_a("FireworksItem", itemStack.func_77955_b(new CompoundNBT()));
        }
        compoundNBT.func_74757_a("ShotAtAngle", this.field_70180_af.func_187225_a(field_213895_d));
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.field_92056_a = compoundNBT.func_74762_e("Life");
        this.field_92055_b = compoundNBT.func_74762_e("LifeTime");
        ItemStack itemStack = ItemStack.func_199557_a(compoundNBT.func_74775_l("FireworksItem"));
        if (!itemStack.func_190926_b()) {
            this.field_70180_af.func_187227_b(field_184566_a, itemStack);
        }
        if (compoundNBT.func_74764_b("ShotAtAngle")) {
            this.field_70180_af.func_187227_b(field_213895_d, compoundNBT.func_74767_n("ShotAtAngle"));
        }
    }

    @Override
    public ItemStack func_184543_l() {
        ItemStack itemStack = this.field_70180_af.func_187225_a(field_184566_a);
        return itemStack.func_190926_b() ? new ItemStack(Items.field_196152_dE) : itemStack;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket(this);
    }
}

